package com.xebialabs.xlrelease.domain.distributed.events

/**
 * Common interface for domain events related to attachment modification.
 */
sealed trait DistributedAttachmentEvent extends DistributedXLReleaseEvent {
  def containerId: String
}

/**
 * Event published when an attachment is created. Attachments are always added to a release, but task attachments
 * are also linked to from tasks. Therefore this event also contains the container ID to easily determine if it is
 * a release or task attachment.
 * @param containerId the ID of the task or release in which the attachment was created.
 * @param attachmentId the created attachment id.
 */
case class DistributedAttachmentCreatedEvent(containerId: String, attachmentId: String) extends DistributedAttachmentEvent

/**
 * Event published when an attachment is deleted.
 * @param containerId the ID of the task or release in which the attachment was created.
 * @param attachmentId the deleted attachment id.
 */
case class DistributedAttachmentDeletedEvent(containerId: String, attachmentId: String) extends DistributedAttachmentEvent
