package com.xebialabs.xlrelease.domain.environments;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false, root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Environment extends BaseConfigurationItem {
    @Property(description = "Name of the environment")
    private String title;

    @Property(required = false, description = "Environment description")
    private String description;

    @Property(description = "Environment stage")
    private EnvironmentStage stage;

    @Property(required = false)
    private List<EnvironmentLabel> labels = new ArrayList<>();

    @PublicApiMember
    public String getDescription() {
        return description;
    }

    @PublicApiMember
    public void setDescription(final String description) {
        this.description = description;
    }

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public EnvironmentStage getStage() {
        return stage;
    }

    @PublicApiMember
    public void setStage(EnvironmentStage stage) {
        this.stage = stage;
    }

    public List<EnvironmentLabel> getLabels() {
        return labels;
    }

    public void setLabels(final List<EnvironmentLabel> labels) {
        this.labels = labels;
    }
}
