package com.xebialabs.xlrelease.domain.environments;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false, root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class EnvironmentReservation extends BaseConfigurationItem {

    @Property(description = "Environment to reserve.")
    private Environment environment;

    @Property(description = "The expected start date.")
    private Date startDate;

    @Property(description = "The expected end date.")
    private Date endDate;

    @Property(required = false, description = "Applications attached to this reservation.")
    private List<Application> applications = new ArrayList<>();

    @Property(required = false, description = "Note for approver.")
    private String note;

    @PublicApiMember
    public Environment getEnvironment() {
        return environment;
    }

    @PublicApiMember
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @PublicApiMember
    public Date getStartDate() {
        return startDate;
    }

    @PublicApiMember
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @PublicApiMember
    public Date getEndDate() {
        return endDate;
    }

    @PublicApiMember
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @PublicApiMember
    public List<Application> getApplications() {
        return applications;
    }

    @PublicApiMember
    public void setApplications(List<Application> applications) {
        this.applications = applications;
    }

    @PublicApiMember
    public void addApplication(Application application) {
        List<Application> applications = new ArrayList<>(getApplications());
        applications.add(application);
        setApplications(applications);
    }

    @PublicApiMember
    public String getNote() {
        return note;
    }

    @PublicApiMember
    public void setNote(String note) {
        this.note = note;
    }
}
