package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.calendar.Blackout

/**
  * Common interface for domain events related to modification of entities on the calendar.
  */
sealed trait CalendarEvent extends XLReleaseEvent

/**
  * Event published when a blackout is created on the calendar.
  *
  * @param blackout the created blackout.
  */
case class BlackoutCreatedEvent(blackout: Blackout) extends CalendarEvent

/**
  * Event published when a blackout is updated on the calendar.
  *
  * @param original a copy of the original blackout.
  * @param updated  updated blackout.
  */
case class BlackoutUpdatedEvent(original: Blackout, updated: Blackout) extends CalendarEvent

/**
  * Event published when a blackout is deleted from the calendar.
  *
  * @param blackout the blackout that was deleted.
  */
case class BlackoutDeletedEvent(blackout: Blackout) extends CalendarEvent
