package com.xebialabs.xlrelease.domain.events

/**
 * Private events related to Release Actor. Do not use them outside product itself.
 */
sealed trait ReleaseActorEvents extends XLReleaseEvent

/**
 * Private event related to Release Actor. Do not use them outside product itself.
 */
case class ReleaseActorStarted(releaseId: String) extends ReleaseActorEvents

/**
 * Private event related to Release Actor. Do not use them outside product itself.
 */
case class ReleaseActorStopped(releaseId: String) extends ReleaseActorEvents
