package com.xebialabs.xlrelease.domain.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.utils.VariableContainerUtils;
import com.xebialabs.xlrelease.variable.VariableHelper;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;
import static com.xebialabs.xlrelease.variable.VariableHelper.indexByKey;

@Metadata(description = "Folder variable container", root = Metadata.ConfigurationItemRoot.APPLICATIONS, versioned = false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class FolderVariables extends BaseConfigurationItem implements InternalMetadata {

    public static final String FOLDER_VARIABLES = "folderVariables";
    public static final String UNSET_VARIABLE_FOLDER_ID = APPLICATIONS.getRootNodeName() + "/{folderId}/variables";

    @Property(asContainment = true, required = false, description = "List of folder variable CIs")
    private List<Variable> variables = new ArrayList<>();

    public FolderVariables() {
        this.setId(UNSET_VARIABLE_FOLDER_ID);
    }

    public FolderVariables(String folderId, List<Variable> variables) {
        this.setId(folderId + "/variables");
        this.setVariables(variables);
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return VariableContainerUtils.getVariables(variables);
    }

    @PublicApiMember
    public Map<String, String> getStringVariableValues() {
        return VariableHelper.getVariableValuesAsStrings(variables);
    }

    @PublicApiMember
    public Map<String, String> getPasswordVariableValues() {
        return VariableHelper.getPasswordVariableValuesAsStrings(variables);
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
        VariableContainerUtils.setVariableContainerDefaults(this.variables);
    }

    public Map<String, Variable> getVariablesByKeys() {
        return indexByKey(variables);
    }

    public Variable addVariable(Variable variable) {
        checkNotNull(variable);
        variable.checkFolderVariableValidity();
        checkArgument(!getVariablesByKeys().containsKey(variable.getKey()), "A variable already exists by key '%s'", variable.getKey());
        VariableContainerUtils.setVariableContainerDefaults(variable);
        variables.add(variable);
        return variable;
    }

}
