package com.xebialabs.xlrelease.domain.variables;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Property;

public class ListOfStringValueProviderConfiguration extends ValueProviderConfiguration {

    private static final String PROPERTY_VALUES = "values";

    @Property(label = "Possible values")
    private List<String> values;

    @Property(asContainment = true, required = false, description = "Map from property name to a variable name that replaces that property")
    private Map<String, String> variableMapping = new HashMap<>();

    public List<String> getValues() {
        return values;
    }

    public void setValues(final List<String> values) {
        this.values = values;
    }

    public Map<String, String> getVariableMapping() {
        return variableMapping;
    }

    public String getVariableKey() {
        return variableMapping.get(PROPERTY_VALUES);
    }

    public void setVariableKey(String variableKey) {
        variableMapping.put(PROPERTY_VALUES, variableKey);
    }
}
