package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false)
public class ExecutionLogPurgeSettings extends BaseConfiguration {

    public static final String EXECUTION_LOG_SETTINGS_ID = "Configuration/settings/ExecutionLogPurgeSettings";

    @Property(defaultValue = "10", required = false, label = "Delete task execution logs older than")
    private Integer executionLogsRetentionPeriod; // in days

    public void validate() {
        Preconditions.checkArgument(executionLogsRetentionPeriod >= 0, "Execution logs retention period must be greater than or equal to 0 days.");
        Preconditions.checkArgument(executionLogsRetentionPeriod <= 45, "Execution logs retention period must be less than 45 days.");
    }

    public Integer getExecutionLogsRetentionPeriod() {
        return executionLogsRetentionPeriod;
    }

    public void setExecutionLogsRetentionPeriod(final Integer executionLogsRetentionPeriod) {
        this.executionLogsRetentionPeriod = executionLogsRetentionPeriod;
    }
}
