package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false)
public class Link extends BaseConfigurationItem {
    @Property(asContainment = true)
    private ParallelGroup parallelGroup;

    @Property
    private Task source;

    @Property
    private Task target;

    public Link() {
    }

    public Link(Task source, Task target) {
        this.source = source;
        this.target = target;
    }

    @PublicApiMember
    public boolean references(Task task) {
        return hasSource(task) || task.equals(target);
    }

    @PublicApiMember
    public boolean hasSource(Task task) {
        return task.equals(source);
    }

    @PublicApiMember
    public ParallelGroup getParallelGroup() {
        return parallelGroup;
    }

    @PublicApiMember
    public void setParallelGroup(ParallelGroup parallelGroup) {
        this.parallelGroup = parallelGroup;
    }

    @PublicApiMember
    public Task getSource() {
        return source;
    }

    @PublicApiMember
    public void setSource(Task source) {
        this.source = source;
    }

    @PublicApiMember
    public Task getTarget() {
        return target;
    }

    @PublicApiMember
    public void setTarget(Task target) {
        this.target = target;
    }

    @PublicApiMember
    public boolean hasTarget(Task task) {
        return task.equals(target);
    }
}
