package com.xebialabs.xlrelease.domain;

import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static com.google.common.base.Preconditions.checkArgument;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label = "Sequential Group", versioned = false)
public class SequentialGroup extends TaskGroup {

    @PublicApiMember
    @Override
    public void setTasks(List<Task> tasks) {
        for (int i = 0; i < tasks.size() - 1; i++) {
            Task t1 = tasks.get(i);
            Task t2 = tasks.get(i + 1);
            checkArgument(
                    areTaskStatusesInAllowableOrder(t1, t2),
                    String.format("Sequential group %s cannot have subtask statuses in this order: %s (on task %s), %s (on task %s)", this.getTitle(), t1.getStatus(), t1.getTitle(), t2.getStatus(), t2.getTitle())
            );
        }
        this.tasks = tasks;
    }

    private boolean areTaskStatusesInAllowableOrder(Task t1, Task t2) {
        return t1.isDefunct() || t2.isNotYetReached();
    }

    @Override
    protected Changes tryToStartPlanningTargets(Task task) {
        Changes changes = new Changes();
        Task target = getPlanningTargetsOf(task);
        if (target == null) return changes;

        if (!task.isActive() && !target.isDefunct()) {
            changes.addAll(target.start());
            if (target.isDone()) {
                changes.addAll(tryToStartPlanningTargets(target));
            }
        }
        return changes;
    }

    private Task getPlanningTargetsOf(Task task) {
        int i = tasks.indexOf(task);
        if (i == -1 || i >= tasks.size() - 1) {
            return null;
        }
        return tasks.get(i + 1);
    }

    @Override
    protected Changes startSubTasksIfPreconditionNotInProgress() {
        Changes changes = new Changes();
        if (isPreconditionInProgress() || isFacetInProgress()) {
            return changes;
        }
        if (tasks.isEmpty()) {
            return changes;
        }

        Task subTask = tasks.get(0);
        changes.addAll(subTask.start());
        if (subTask.isDone()) {
            changes.addAll(tryToStartPlanningTargets(subTask));
        }

        return changes;
    }

}
