package com.xebialabs.xlrelease.domain.events

/**
  * Implementations of this interface are types of events which notify that a certain domain action
  * is going to happen in Digital.ai Release. They can be used to intercept the action by for example throwing
  * an exception.
  *
  * '''This is an experimental feature.''' Plugins must not rely on these classes as they can be removed in the
  * next releases.
  */
trait InterceptableAction extends XLReleaseEvent

// Release execution
case class ReleaseStartingAction(releaseId: String) extends InterceptableAction
case class ReleasePausingAction(releaseId: String) extends InterceptableAction
case class ReleaseResumingAction(releaseId: String) extends InterceptableAction
case class ReleaseRetryingAction(releaseId: String) extends InterceptableAction
case class ReleaseAbortingAction(releaseId: String) extends InterceptableAction
case class ReleaseCompletingAction(releaseId: String) extends InterceptableAction
case class ReleaseAbortScriptsAction(releaseId: String) extends InterceptableAction

// Phase execution
case class PhaseStartingAction(phaseId: String) extends InterceptableAction
case class PhaseRetryingAction(phaseId: String) extends InterceptableAction
case class PhaseCompletingAction(phaseId: String) extends InterceptableAction
case class PhaseClosingAction(phaseId: String) extends InterceptableAction

// Task execution
case class TaskStartingAction(taskId: String) extends InterceptableAction
case class TaskCompletingAction(taskId: String, inAdvance: Boolean) extends InterceptableAction
case class TaskSkippingAction(taskId: String, inAdvance: Boolean) extends InterceptableAction
case class TaskAbortingAction(taskId: String) extends InterceptableAction
case class TaskRetryingAction(taskId: String) extends InterceptableAction
case class TaskDelayingAction(taskId: String) extends InterceptableAction
case class TaskFailingAction(taskId: String, reason: String) extends InterceptableAction
case class TaskReopeningAction(taskId: String) extends InterceptableAction

trait TemplateAction extends InterceptableAction {
  def templateId: String
}
case class TemplateMovingAction(templateId: String, destinationFolderId: String) extends TemplateAction
case class TemplateDeletingAction(templateId: String) extends TemplateAction

// Folder execution
trait FolderAction extends InterceptableAction {
  def folderId: String
}
case class FolderDeletingAction(folderId: String) extends FolderAction
case class FolderMovingAction(folderId: String, oldParentId: String, newParentId: String) extends FolderAction
