package com.xebialabs.xlrelease.domain.udm.reporting;

import java.util.Date;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;

import static com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label = "Build", description = "Unified Data Model for Build")
public class BuildRecord extends TaskReportingRecord {

    @Property(category = CATEGORY_INPUT, label = "Project", description = "The project name.")
    private String project;

    @Property(category = CATEGORY_INPUT, label = "Build id", description = "The ID of the build.")
    private String build;

    @Property(category = CATEGORY_INPUT, label = "Build result", description = "Result of the build.")
    private String outcome;

    @Property(category = CATEGORY_INPUT, label = "Build start", description = "Start date of the build.")
    private Date startDate;

    @Property(category = CATEGORY_INPUT, label = "Build end", description = "End date of the build.")
    private Date endDate;

    @Property(category = CATEGORY_INPUT, label = "Build duration", description = "Duration of the build.")
    private String duration;

    @Property(category = CATEGORY_INPUT, label = "Build URL", description = "Link to the job build.")
    private String build_url;

    @PublicApiMember
    public String getProject() {
        return project;
    }

    @PublicApiMember
    public void setProject(final String project) {
        this.project = project;
    }

    @PublicApiMember
    public String getBuild() {
        return build;
    }

    @PublicApiMember
    public void setBuild(final String build) {
        this.build = build;
    }

    @PublicApiMember
    public String getOutcome() {
        return outcome;
    }

    @PublicApiMember
    public void setOutcome(final String outcome) {
        this.outcome = outcome;
    }

    @PublicApiMember
    public Date getStartDate() {
        return startDate;
    }

    @PublicApiMember
    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    @PublicApiMember
    public Date getEndDate() {
        return endDate;
    }

    @PublicApiMember
    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    @PublicApiMember
    public String getDuration() {
        return duration;
    }

    @PublicApiMember
    public void setDuration(final String duration) {
        this.duration = duration;
    }

    @PublicApiMember
    public String getBuild_url() {
        return build_url;
    }

    @PublicApiMember
    public void setBuild_url(final String build_url) {
        this.build_url = build_url;
    }

}
