/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.Variable;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class BooleanVariable
extends Variable.VariableWithValue<Boolean> {
    @PublicApiMember
    @Property(required=false, description="Value of the release variable or default value of the template variable")
    protected boolean value;

    @Override
    @PublicApiMember
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public Boolean getEmptyValue() {
        return false;
    }

    @Override
    public boolean isValueEmpty() {
        return false;
    }

    @Override
    @PublicApiMember
    public void setValue(Boolean value) {
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setUntypedValue(Object newValue) {
        if (newValue instanceof Boolean) {
            this.setValue((Boolean)newValue);
            return;
        } else if (newValue instanceof String) {
            String newValueString = (String)newValue;
            if (!newValueString.equalsIgnoreCase("true") && !newValueString.equalsIgnoreCase("false")) throw new IllegalArgumentException(String.format("Cannot set instance of %s into boolean variable value: %s", newValue.getClass().getSimpleName(), newValue));
            this.setValue(Boolean.valueOf(newValueString));
            return;
        } else {
            if (newValue != null) throw new IllegalArgumentException(String.format("Cannot set instance of %s into boolean variable value: %s", newValue.getClass().getSimpleName(), newValue));
            this.setValue(this.getEmptyValue());
        }
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getValueAsString() {
        return this.value ? "True" : "False";
    }

    @Override
    public String getEmptyValueAsString() {
        return "False";
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return value instanceof Boolean;
    }
}

