package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false)
public class ReportsSettings extends BaseConfiguration {
    public static final String REPORTS_SETTINGS_ID = "Configuration/reports/ReportsSettings";

    @Property(defaultValue = "2", required = false, label = "Number of incidents for Warning alert")
    private Integer warningThreshold;

    @Property(defaultValue = "4", required = false, label = "Number of incidents for Error alert")
    private Integer errorThreshold;

    @Property(defaultValue = "6", required = false, label = "Number of incidents for Critical Phase alert")
    private Integer criticalPhaseThreshold;

    public void validate() {
        Preconditions.checkArgument(warningThreshold >= 0, "Warning threshold must be greater than or equal to 0.");
        Preconditions.checkArgument(errorThreshold >= 0, "Error threshold must be greater than or equal to 0.");
        Preconditions.checkArgument(criticalPhaseThreshold >= 0, "Critical phase threshold must be greater than or equal to 0.");
    }

    public Integer getWarningThreshold() {
        return warningThreshold;
    }

    public void setWarningThreshold(final Integer warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    public Integer getErrorThreshold() {
        return errorThreshold;
    }

    public void setErrorThreshold(final Integer errorThreshold) {
        this.errorThreshold = errorThreshold;
    }

    public Integer getCriticalPhaseThreshold() {
        return criticalPhaseThreshold;
    }

    public void setCriticalPhaseThreshold(final Integer criticalPhaseThreshold) {
        this.criticalPhaseThreshold = criticalPhaseThreshold;
    }
}
