package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.Map;

import static com.xebialabs.xlrelease.repository.Ids.SEPARATOR;

@Metadata(versioned = false)
public class RoleIdExtension extends ReleaseExtension {
    public static final String ROLE_IDS_METADATA_PREFIX = "roleIds";

    public RoleIdExtension() {}

    public RoleIdExtension(String ciId, Map<String, String> idsToRoleName) {
        this.id = ciId + SEPARATOR + ROLE_IDS_METADATA_PREFIX;
        this.idsToRoleName = idsToRoleName;
    }

    @Property(description = "Map of Role ids to Role names")
    private Map<String, String> idsToRoleName;

    public Map<String, String> getIdsToRoleName() {
        return idsToRoleName;
    }

    public void setIdsToRoleName(Map<String, String> idsToRoleName) {
        this.idsToRoleName = idsToRoleName;
    }

    @Override
    public boolean equals(Object thatObject) {
        if (!super.equals(thatObject)) return false;
        if (!(thatObject instanceof RoleIdExtension)) return false;
        return this.idsToRoleName.equals(((RoleIdExtension) thatObject).idsToRoleName);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

}
