package com.xebialabs.xlrelease.domain.udm.reporting;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum DeploymentStatus {
    PLANNED("planned"),
    IN_PROGRESS("in_progress"),
    COMPLETED("completed"),
    SKIPPED("skipped"),
    FAILED("failed"),
    ABORTED("aborted");

    private final String value;

    DeploymentStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static DeploymentStatus find(String value) {
        for (DeploymentStatus status : DeploymentStatus.values()) {
            if (status.value().equals(value)) {
                return status;
            }
        }

        throw new IllegalStateException(String.format("Unknown deployment status [%s].", value));
    }

}
