package com.xebialabs.xlrelease.risk.domain.progress;

import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.ReleaseExtension;

@Metadata(versioned = false, description = "Summary of release progress")
public class ReleaseProgress extends ReleaseExtension {
    public static final String PROGRESS_PREFIX = "progress";

    @Property
    private int totalTasks;

    @Property
    private int totalRemainingTasks;

    @Property
    private Map<String, String> phasesProgress = new HashMap<>();

    public Map<String, String> getPhasesProgress() {
        return phasesProgress;
    }

    public void setPhasesProgress(final Map<String, String> phasesProgress) {
        this.phasesProgress = phasesProgress;
    }

    public int getTotalTasks() {
        return totalTasks;
    }

    public void setTotalTasks(final int totalTasks) {
        this.totalTasks = totalTasks;
    }

    public int getTotalRemainingTasks() {
        return totalRemainingTasks;
    }

    public void setTotalRemainingTasks(final int totalRemainingTasks) {
        this.totalRemainingTasks = totalRemainingTasks;
    }
}
