package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false, label = "Task execution log purging", description = "Release will use this setting to delete task execution logs that have been stored on the server. After deletion, task execution logs can no longer be visible or downloaded.")
public class ExecutionLogPurgeSettings extends BaseSettings {

    public static final String EXECUTION_LOG_SETTINGS_ID = BASE_ID + "ExecutionLogPurgeSettings";

    @Property(defaultValue = "archive", hidden = true)
    private String displayIcon;

    @Property(defaultValue = "tasks-settings", hidden = true)
    private String displayPage;

    @Property(defaultValue = "how-to/configure-tasks.html", hidden = true)
    private String documentationPage;

    @Property(defaultValue = "20", hidden = true)
    private Integer weight;

    @Property(defaultValue = "10", required = false, label = "Delete Task execution logs older than")
    private Integer executionLogsRetentionPeriod; // in days

    public void validate() {
        Preconditions.checkArgument(executionLogsRetentionPeriod >= 0, "Execution logs retention period must be greater than or equal to 0 days.");
        Preconditions.checkArgument(executionLogsRetentionPeriod <= 45, "Execution logs retention period must be less than 45 days.");
    }

    public Integer getExecutionLogsRetentionPeriod() {
        return executionLogsRetentionPeriod;
    }

    public void setExecutionLogsRetentionPeriod(final Integer executionLogsRetentionPeriod) {
        this.executionLogsRetentionPeriod = executionLogsRetentionPeriod;
    }
}
