package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false, label = "Value Stream reports", description = "Release will use these settings in the Release Value Stream report.")
public class ReportsSettings extends BaseSettings {
    public static final String REPORTS_SETTINGS_ID =  BASE_ID + "ReportsSettings";

    @Property(defaultValue = "report", hidden = true)
    private String displayIcon;

    @Property(defaultValue = "reports-settings", hidden = true)
    private String displayPage;

    @Property(defaultValue = "concept/release-value-stream-report.html", hidden = true)
    private String documentationPage;

    @Property(defaultValue = "10", hidden = true)
    private Integer weight;

    @Property(defaultValue = "2", required = false, label = "Show Warning alert for")
    private Integer warningThreshold;

    @Property(defaultValue = "4", required = false, label = "Show Error alert for")
    private Integer errorThreshold;

    @Property(defaultValue = "6", required = false, label = "Show Critical Phase alert for")
    private Integer criticalPhaseThreshold;

    public void validate() {
        Preconditions.checkArgument(warningThreshold >= 0, "Warning threshold must be greater than or equal to 0.");
        Preconditions.checkArgument(errorThreshold >= 0, "Error threshold must be greater than or equal to 0.");
        Preconditions.checkArgument(criticalPhaseThreshold >= 0, "Critical phase threshold must be greater than or equal to 0.");
    }

    public Integer getWarningThreshold() {
        return warningThreshold;
    }

    public void setWarningThreshold(final Integer warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    public Integer getErrorThreshold() {
        return errorThreshold;
    }

    public void setErrorThreshold(final Integer errorThreshold) {
        this.errorThreshold = errorThreshold;
    }

    public Integer getCriticalPhaseThreshold() {
        return criticalPhaseThreshold;
    }

    public void setCriticalPhaseThreshold(final Integer criticalPhaseThreshold) {
        this.criticalPhaseThreshold = criticalPhaseThreshold;
    }
}
