package com.xebialabs.xlrelease.configuration;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.xlrelease.domain.BaseSettings;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false, label = "Triggers data purging", description = "Release will use these settings to purge trigger execution data.")
public class TriggerDataPurgeSettings extends BaseSettings {

    public static final String TRIGGER_DATA_PURGE_SETTINGS_ID = BASE_ID + "TriggerDataPurgeSettings";

    @Property(defaultValue = "trigger", hidden = true)
    private String displayIcon;

    @Property(defaultValue = "releases-settings", hidden = true)
    private String displayPage;

    @Property(defaultValue = "how-to/configure-releases-triggers.html", hidden = true)
    private String documentationPage;

    @Property(defaultValue = "30", hidden = true)
    private Integer weight;

    @Property(defaultValue = "false", required = false, label = "Enable purging of Trigger data")
    private boolean enabled;

    @Property(defaultValue = "720", required = false, label = "Purge Trigger data older than")
    @Range(minimum = 1, message = "Purge Trigger must be greater than or equal to 1 hour")
    private Integer triggersDataPurgeAgeThreshold; // in hours (30 days default)

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getTriggersDataPurgeAgeThreshold() {
        return triggersDataPurgeAgeThreshold;
    }

    public void setTriggersDataPurgeAgeThreshold(Integer triggersDataPurgeAgeThreshold) {
        this.triggersDataPurgeAgeThreshold = triggersDataPurgeAgeThreshold;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        final TriggerDataPurgeSettings that = (TriggerDataPurgeSettings) o;

        if (isEnabled() != that.isEnabled()) return false;
        return getTriggersDataPurgeAgeThreshold() != null ?
                getTriggersDataPurgeAgeThreshold().equals(that.getTriggersDataPurgeAgeThreshold()) :
                that.getTriggersDataPurgeAgeThreshold() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (isEnabled() ? 1 : 0);
        result = 31 * result + (getTriggersDataPurgeAgeThreshold() != null ?
                getTriggersDataPurgeAgeThreshold().hashCode() : 0);
        return result;
    }

}
