package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.xebialabs.xlrelease.repository.Ids.isConfigurationId;

/**
 * Base class for configuration and all global settings in the application.
 */
@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false, virtual = true)
public class BaseConfiguration extends BaseConfigurationItem {

    @Property(description = "If set, this field contains the folder that this configuration belongs to.", required = false, category = "FOLDER_CONFIG")
    private String folderId;

    @PublicApiMember
    public String getFolderId() {
        return folderId;
    }

    @PublicApiMember
    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public boolean hasId() {
        return !isNullOrEmpty(getId()) && isConfigurationId(getId());
    }

    // abstract methods to be overridden by children which might have a title
    public String getTitle() {
        return null;
    }

    public void setTitle(String title) {
    }

}
