package com.xebialabs.xlrelease.domain;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer;

@JsonSerialize(using = CiSerializer.class)
@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false)
public class Category extends BaseConfigurationItem {

    private Integer ciUid;

    @Property
    private String title;

    @Property
    private boolean active;

    public Category() {

    }

    public Category(final String title, final boolean active) {
        this.title = title;
        this.active = active;
    }

    @PublicApiMember
    public Integer getCiUid() {
        return ciUid;
    }

    @PublicApiMember
    public void setCiUid(final Integer ciUid) {
        this.ciUid = ciUid;
        this.setId(ciUid != null ? ciUid.toString() : null);
    }

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(final String title) {
        this.title = title;
    }

    @PublicApiMember
    public Boolean getActive() {
        return active;
    }

    @PublicApiMember
    public void setActive(final boolean active) {
        this.active = active;
    }

    public static String sanitizeTitle(String title) {
        if (StringUtils.hasText(title)) {
            return title.trim().replaceAll(" +", " ");
        }
        return title;
    }

    public static Set<String> sanitizeTitles(Set<String> titles) {
        if (titles != null) {
            return titles.stream()
                    .map(Category::sanitizeTitle)
                    .filter(StringUtils::hasText)
                    .collect(Collectors.toCollection(HashSet::new));
        }
        return new HashSet<>();
    }
}
