package com.xebialabs.xlrelease.domain;

import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

/**
 * Base class for configuration.
 * Users subclass this in <code>synthetic.xml</code> to configure properties.
 */
@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false, virtual = true)
public class Configuration extends BaseConfiguration {

    @Property(description = "Symbolic name for the configuration")
    private String title;

    @Property(asContainment = true, required = false, description = "Map from property name to a variable name that replaces that property")
    private Map<String, String> variableMapping = new HashMap<>();

    @Override
    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @Override
    @PublicApiMember
    public void setTitle(final String title) {
        this.title = title;
    }

    public void setVariableMapping(final Map<String, String> variableMapping) {
        // create modifiable variable mapping
        this.variableMapping = new HashMap<>(variableMapping);
    }

    public Map<String, String> getVariableMapping() {
        return variableMapping;
    }

    public boolean hasVariableMapping() {
        return variableMapping != null && !variableMapping.isEmpty();
    }
}
