package com.xebialabs.xlrelease.domain

import com.fasterxml.jackson.databind.annotation.JsonSerialize
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer

import java.util.Date
import scala.beans.BeanProperty

/**
 * This class represents a personal access token data for the user.
 * Table also has token hash value which is not added in domain class to prevent any potential leak in logs, events etc.
 */
@JsonSerialize(using = classOf[CiSerializer])
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false)
class UserToken extends BaseConfigurationItem {

  @BeanProperty
  @Property
  var ciUid: Integer = _

  @BeanProperty
  @Property
  var username: String = _

  @BeanProperty
  @Property
  var tokenNote: String = _

  @BeanProperty
  @Property
  var createdDate: Date = _

  @BeanProperty
  @Property
  var lastUsedDate: Date = _

  @BeanProperty
  @Property
  var expiryDate: Date = _

  @BeanProperty
  @Property
  var expiryNotified: Boolean = _

  @Property(isTransient = true, required = false, readonly = true)
  var token: String = _

  override def toString: String = s"UserToken {username=$username, tokenNote:$tokenNote}"

  def isExpired(): Boolean = null != expiryDate && expiryDate.getTime < System.currentTimeMillis()
}
