package com.xebialabs.xlrelease.domain.configuration;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.PropertyConfiguration;

/**
 * Base class for server configurations which use HTTP connection properties.
 * Users subclass this in <code>synthetic.xml</code> to configure additional properties.
 */
@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, virtual = true, versioned = false)
public class HttpConnection extends PropertyConfiguration {

    @PublicApiRef
    @ShowOnlyPublicApiMembers
    public enum AuthenticationMethod {
        None,
        Basic,
        Ntlm,
        PAT,
        OAuth2
    }

    @PublicApiRef
    @ShowOnlyPublicApiMembers
    public enum OAuth2GrantType {
        Password,
        ClientCredentials
    }

    @Property(description = "Address where the server can be reached", label = "URL")
    private String url;

    @Property(label = "Authentication method", required = false, defaultValue = "Basic")
    private AuthenticationMethod authenticationMethod;

    @Property(required = false, description = "Login user ID on the server", category = "Authentication")
    private String username;

    @Property(password = true, required = false, description = "Login user password on the server", category = "Authentication")
    private String password;

    @Property(description = "Domain to be used for NTLM authentication", required = false, label = "Domain", category = "Authentication")
    private String domain;

    @Property(description = "Authorization grant type", label = "Grant type", hidden = true)
    private OAuth2GrantType oauth2GrantType = OAuth2GrantType.Password;

    @Property(description = "The endpoint of the authentication server", label = "Access token URL", category = "Authentication", required = false)
    private String accessTokenUrl;

    @Property(description = "The client identifier issued to the client during the Application registration process", label = "Client ID", category = "Authentication", required = false)
    private String clientId;

    @Property(description = "The client secret issued to the client during the Application registration process", label = "Client secret", category = "Authentication", required = false, password = true)
    private String clientSecret;

    @Property(description = "The scope of the access request. It may have multiple space-delimited values", label = "Scope", category = "Authentication", required = false)
    private String scope;

    @Property(required = false, label = "Proxy host", description = "HTTP proxy host", category = "Proxy")
    private String proxyHost;

    @Property(required = false, label = "Proxy port", description = "HTTP proxy port", category = "Proxy")
    private String proxyPort;

    @Property(required = false, label = "Proxy username", description = "HTTP proxy username", category = "Proxy")
    private String proxyUsername;

    @Property(password = true, label = "Proxy password", required = false, description = "HTTP proxy password", category = "Proxy")
    private String proxyPassword;

    @Property(required = false, label = "Proxy domain", description = "Domain to be used for NTLM proxy authentication", category = "Proxy")
    private String proxyDomain;

    public HttpConnection() {
    }

    public HttpConnection(Map<String, String> map) {
        this.url = map.get("url");
        this.username = map.get("username");
        this.password = map.get("password");
        this.proxyHost = map.get("proxyHost");
        this.proxyPort = map.get("proxyPort");
        this.proxyUsername = map.get("proxyUsername");
        this.proxyPassword = map.get("proxyPassword");
        this.proxyDomain = map.get("proxyDomain");
        this.accessTokenUrl = map.get("accessTokenUrl");
        this.clientId = map.get("clientId");
        this.clientSecret = map.get("clientSecret");
        this.scope = map.get("scope");
    }


    //
    // Getters & setters
    //
    @PublicApiMember
    public String getUrl() {
        return url;
    }

    @PublicApiMember
    public void setUrl(String url) {
        this.url = url;
    }

    @PublicApiMember
    public AuthenticationMethod getAuthenticationMethod() {
        return authenticationMethod;
    }

    @PublicApiMember
    public void setAuthenticationMethod(final AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @PublicApiMember
    public String getUsername() {
        return username;
    }

    @PublicApiMember
    public void setUsername(String username) {
        this.username = username;
    }

    @PublicApiMember
    public String getPassword() {
        return password;
    }

    @PublicApiMember
    public void setPassword(String password) {
        this.password = password;
    }

    @PublicApiMember
    public String getDomain() {
        return domain;
    }

    @PublicApiMember
    public void setDomain(final String domain) {
        this.domain = domain;
    }

    @PublicApiMember
    public OAuth2GrantType getOauth2GrantType() {
        return oauth2GrantType;
    }

    @PublicApiMember
    public void setOauth2GrantType(final OAuth2GrantType oauth2GrantType) {
        this.oauth2GrantType = oauth2GrantType;
    }

    @PublicApiMember
    public String getAccessTokenUrl() {
        return accessTokenUrl;
    }

    @PublicApiMember
    public void setAccessTokenUrl(final String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    @PublicApiMember
    public String getClientId() {
        return clientId;
    }

    @PublicApiMember
    public void setClientId(final String clientId) {
        this.clientId = clientId;
    }

    @PublicApiMember
    public String getClientSecret() {
        return clientSecret;
    }

    @PublicApiMember
    public void setClientSecret(final String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @PublicApiMember
    public String getScope() {
        return scope;
    }

    @PublicApiMember
    public void setScope(final String scope) {
        this.scope = scope;
    }

    @PublicApiMember
    public String getProxyHost() {
        return proxyHost;
    }

    @PublicApiMember
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @PublicApiMember
    public String getProxyPort() {
        return proxyPort;
    }

    @PublicApiMember
    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @PublicApiMember
    public String getProxyUsername() {
        return proxyUsername;
    }

    @PublicApiMember
    public void setProxyUsername(final String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @PublicApiMember
    public String getProxyPassword() {
        return proxyPassword;
    }

    @PublicApiMember
    public void setProxyPassword(final String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @PublicApiMember
    public String getProxyDomain() {
        return proxyDomain;
    }

    @PublicApiMember
    public void setProxyDomain(final String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

}
