package com.xebialabs.xlrelease.domain.delivery;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public enum TrackedItemStatus {
    NOT_READY("not_ready"),
    READY("ready"),
    SKIPPED("skipped");

    private final String value;

    TrackedItemStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static final TrackedItemStatus[] DONE_STATUSES = new TrackedItemStatus[]{READY, SKIPPED};

    public boolean isDone() {
        return isOneOf(DONE_STATUSES);
    }

    public boolean isOneOf(TrackedItemStatus... statuses) {
        for (TrackedItemStatus status : statuses) {
            if (this == status) {
                return true;
            }
        }

        return false;
    }
}
