package com.xebialabs.xlrelease.domain.group;

import java.util.*;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.domain.CiWithInternalMetadata;
import com.xebialabs.xlrelease.repository.Ids;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;
import static com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus.ABORTED;
import static com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus.COMPLETED;
import static java.util.stream.Collectors.toSet;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = APPLICATIONS, versioned = false, description = "A grouping of multiple releases.")
public class ReleaseGroup extends BaseConfigurationItem implements CiWithInternalMetadata {
    public static final String GROUP_ROOT = APPLICATIONS.getRootNodeName();

    /**
     * An additional derived Release metadata that is used in our UI. Does not
     * belong to public API and can be changed. See implementations of com.xebialabs.xlrelease.api.internal.InternalMetadataDecorator
     * for usages.
     */
    private Map<String, InternalMetadata> $metadata = new LinkedHashMap<>();

    @Property(description = "Symbolic name for the release group.")
    private String title;

    @Property(description = "The state the release group is in.")
    private ReleaseGroupStatus status = ReleaseGroupStatus.PLANNED;

    @Property(required = false, description = "The expected start date.")
    protected Date startDate;

    @Property(required = false, description = "The expected end date.")
    protected Date endDate;

    @Property(defaultValue = "0", description = "The worst risk score of the contained releases.")
    private Integer riskScore = 0;

    @Property(required = false, description = "List of releases contained by this release group.")
    private Set<String> releaseIds = new HashSet<>();

    @Property(required = false, description = "Release group progress")
    private Integer progress = 0;

    @Property(required = false, isTransient = true, description = "Folder that the release group belongs to")
    private String folderId;

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(final String title) {
        this.title = title;
    }

    @PublicApiMember
    public ReleaseGroupStatus getStatus() {
        return status;
    }

    @PublicApiMember
    public void setStatus(final ReleaseGroupStatus status) {
        this.status = status;
    }

    @PublicApiMember
    public Date getStartDate() {
        return startDate;
    }

    @PublicApiMember
    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    @PublicApiMember
    public Date getEndDate() {
        return endDate;
    }

    @PublicApiMember
    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    @PublicApiMember
    public Integer getRiskScore() {
        return riskScore;
    }

    @PublicApiMember
    public void setRiskScore(final Integer riskScore) {
        this.riskScore = riskScore;
    }

    @PublicApiMember
    public Set<String> getReleaseIds() {
        return releaseIds;
    }

    public void removeReleaseIds(List<String> idsToRemove) {
        //quite messy so need to figure out a different way to accept the different ways an id is passed in
        List<String> strippedIds = idsToRemove.stream().map(Ids::getName).collect(Collectors.toList());
        releaseIds = releaseIds.stream().filter(id -> !strippedIds.contains(Ids.getName(id))).collect(toSet());
    }

    @PublicApiMember
    public void setReleaseIds(final Set<String> releaseIds) {
        this.releaseIds = releaseIds;
    }

    @PublicApiMember
    public Integer getProgress() {
        return progress;
    }

    @PublicApiMember
    public void setProgress(final Integer progress) {
        this.progress = progress;
    }

    public boolean isUpdatable() {
        return !COMPLETED.equals(status) && !ABORTED.equals(status);
    }

    @PublicApiMember
    public String getFolderId() {
        return folderId;
    }

    @PublicApiMember
    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    @Override
    public Map<String, InternalMetadata> get$metadata() {
        return $metadata;
    }
}
