package com.xebialabs.xlrelease.domain.variables;

import java.util.Objects;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.ExternalVariableServer;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false)
public class ExternalVariableValue extends BaseConfigurationItem {
    
    public static final String CONFIGURATION_ID = "externalVariableValue";
    
    public ExternalVariableValue() {
    }
    
    public ExternalVariableValue(final ExternalVariableServer server, final String path, final String externalKey) {
        this.server = server;
        this.path = path;
        this.externalKey = externalKey;
    }
    
    @PublicApiMember
    @Property(required = false, description = "Reference to the external variable server")
    private ExternalVariableServer server;
    
    @PublicApiMember
    @Property(required = false, description = "Path on the external server")
    private String path;
    
    @PublicApiMember
    @Property(required = false, description = "Key to retrieve secret")
    private String externalKey;
    
    public ExternalVariableServer getServer() {
        return server;
    }
    
    public void setServer(final ExternalVariableServer server) {
        this.server = server;
    }
    
    public String getPath() {
        return path;
    }
    
    public void setPath(final String path) {
        this.path = path;
    }
    
    public String getExternalKey() {
        return externalKey;
    }
    
    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        if (!super.equals(o)) {
            return false;
        }

        final ExternalVariableValue that = (ExternalVariableValue) o;
        return Objects.equals(server, that.server) &&
                Objects.equals(path, that.path) &&
                Objects.equals(externalKey, that.externalKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), server, path, externalKey);
    }
}
