package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static java.lang.String.format;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class IntegerVariable extends Variable.VariableWithValue<Integer> {

    @PublicApiMember
    @Property(required = true, description = "Value of the release variable or default value of the template variable")
    protected int value;

    @PublicApiMember
    @Override
    public Integer getValue() {
        return value;
    }

    @Override
    public Integer getEmptyValue() {
        return 0;
    }

    @PublicApiMember
    @Override
    public void setValue(final Integer value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        if (newValue == null) {
            this.setValue(this.getEmptyValue());
            return;
        }
        if (newValue instanceof Integer) {
            this.setValue((Integer) newValue);
        } else if (newValue instanceof String) {
            handleStringValue(newValue.toString());
        } else {
            throw new IllegalArgumentException(format("Cannot set instance of %s into integer variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    private void handleStringValue(final String newValue) {
        if (newValue.isBlank()) {
            this.setValue(this.getEmptyValue());
        } else {
            try {
                this.setValue(Integer.valueOf(newValue));
            } catch (NumberFormatException e) {
                throw new IllegalArgumentException(format("Cannot set instance of %s into integer variable value: %s", newValue.getClass().getSimpleName(), newValue), e);
            }
        }
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getValueAsString() {
        return Integer.toString(value);
    }

    @Override
    public String getEmptyValueAsString() {
        return "0";
    }

    @Override
    public boolean isValueEmpty() {
        return false;
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return (value instanceof Integer);
    }
}