package com.xebialabs.xlrelease.domain.variables.reference

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.repository.CiProperty

import java.util
import scala.jdk.CollectionConverters._

class ReleaseVariablesUsagePoint(release: Release) extends UsagePoint {
  def collectVariables(): util.Map[String, VariableReference.VariableUsageType] = {
    for {
      variable <- release.getVariables.asScala
      variableUsagePoint = new VariableUsagePoint(variable)
      usagePoint <- variableUsagePoint.collectVariables().asScala
    } yield usagePoint
  }.toMap.asJava

  def replaceVariable(toReplace: Variable, replacement: VariableOrValue): util.Set[ConfigurationItem] = {
    for {
      variable <- release.getVariables.asScala
      if variable.getKey != toReplace.getKey
      variableUsagePoint = new VariableUsagePoint(variable)
      replaced <- variableUsagePoint.replaceVariable(toReplace, replacement).asScala
    } yield replaced
  }.toSet.asJava


  def getTargetProperty: CiProperty = CiProperty.of(release, "variables").orElse(null)
}
