package com.xebialabs.xlrelease.domain.variables.reference;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;


public class VariableReference implements Comparable<VariableReference> {

    public enum VariableUsageType {
        DEFAULT(0),
        CI_PROPERTY(-1),
        GLOBAL(-1),
        FOLDER(-1),
        SCRIPT_RESULT(2),
        PASSWORD(3);

        private int priority;

        VariableUsageType(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return priority;
        }

        public boolean hasHigherPriorityThan(VariableUsageType variableType) {
            return getPriority() > variableType.getPriority();
        }
    }

    private String key;
    private VariableUsageType type;
    private Set<UsagePoint> usagePoints = new HashSet<>();

    public VariableReference(String key, VariableUsageType variableType) {
        this.key = key;
        this.type = variableType;
    }

    public String getKey() {
        return key;
    }

    public VariableUsageType getType() {
        return type;
    }

    public void setType(VariableUsageType type) {
        this.type = type;
    }

    public Set<UsagePoint> getUsagePoints() {
        return usagePoints;
    }

    public void addUsagePoint(UsagePoint usagePoint, VariableUsageType usagePointType) {
        if (usagePointType.hasHigherPriorityThan(getType())) {
            setType(usagePointType);
        }
        usagePoints.add(usagePoint);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof VariableReference)) {
            return false;
        }
        VariableReference that = (VariableReference) other;
        return Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }

    @Override
    public int compareTo(VariableReference that) {
        if (null == that) return 1;
        return this.key.compareTo(that.key);
    }

}
