package com.xebialabs.xlrelease.risk.domain.riskassessors;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;

@Metadata(label = "ReleaseDueDateAssessor", versioned = false)
public class ReleaseDueDateRiskAssessor extends PlanItemDueDateRiskAssessor {

    private static final String RELEASE_OVERDUE_HEADLINE = "Release is overdue";

    @Override
    public RiskAssessment execute(final Release release, final RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());

        List<String> messages = new ArrayList<>();
        if (release.isOverdue()) {
            assessment.setScore(riskProfile.getValueFor(getType()));
                assessment.setHeadline(RELEASE_OVERDUE_HEADLINE);
            messages.add(formatMessage(release).trim());
        } else {
            assessment.setScore(OK_SCORE);
            assessment.setHeadline(OK_HEADLINE);
        }
        assessment.setMessages(messages);
        return assessment;
    }
}
