package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;

import static com.xebialabs.xlrelease.domain.status.FlagStatus.AT_RISK;

@Metadata(label = "TaskWithXFlagsAtRiskRiskAssessor", versioned = false, virtual = true)
public class TaskWithXFlagsAtRiskRiskAssessor extends TaskFlagRiskAssessor {

    public static final String TASKS_AT_RISK_HEADLINE = "Release has tasks flagged as red";


    @Override
    protected int getScore(final int numberOfFlaggedTasks, final RiskProfile riskProfile) {
        if (numberOfFlaggedTasks >= minFlags && numberOfFlaggedTasks <= maxFlags)
            return riskProfile.getValueFor(getType());

        return 0;
    }

    @Override
    public RiskAssessment execute(final Release release, final RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        return executeForFlag(assessment, release, riskProfile, AT_RISK, TASKS_AT_RISK_HEADLINE);
    }

}
