/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false, label="Releases and workflows archiving and clean-up", description="Release will use these settings to archive completed releases. Note: Only archived releases appear in reports.")
public class ArchivingSettings
extends BaseSettings {
    public static final String ARCHIVING_SETTINGS_ID = "Configuration/settings/ArchivingSettings";
    @Property(defaultValue="archive", hidden=true)
    private String displayIcon;
    @Property(defaultValue="releases-settings", hidden=true)
    private String displayPage;
    @Property(defaultValue="how-to/configure-releases-triggers.html", hidden=true)
    private String documentationPage;
    @Property(defaultValue="0", hidden=true)
    private Integer weight;
    public static final int DEFAULT_SEARCH_PAGE_SIZE = 20;
    private static final String DEFAULT_SEARCH_PAGE_SIZE_AS_STRING = "20";
    @Property(defaultValue="720", required=false, label="Archive executions older than", description="Applicable to completed and aborted releases and workflows")
    private Integer releaseAgeToDeleteFromJcr;
    @Property(defaultValue="16 * * * * *", required=false, hidden=true, label="Schedule for the job that checks for releases to archive (advanced)")
    private String archivingJobCronSchedule;
    @Property(defaultValue="true", required=false, hidden=true, label="Enable archiving")
    private boolean enabled;
    @Property(defaultValue="true", required=false, hidden=true, label="Enable pre-archiving")
    private boolean preArchivingEnabled;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of archivable releases to retrieve from the repository in a single search query")
    private Integer searchPageSize;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of seconds that archiving is allowed to run before it is paused until the next time it is scheduled")
    private Integer maxSecondsPerRun;
    @Property(defaultValue="1", required=false, hidden=true, label="Number of seconds to sleep between archiving individual releases within a single run")
    private Integer sleepSecondsBetweenReleases;
    @Property(defaultValue="false", required=false, label="Enable purging of archived executions")
    private boolean purgingEnabled;
    @Property(defaultValue="purged", required=false, label="Export path", description="The path relative to the install root to store purged Release data")
    private String purgeExportPath;
    @Property(defaultValue="true", required=false, label="Export execution data when purging")
    private boolean exportOnPurgeEnabled;
    @Property(defaultValue="8760", required=false, label="Maximum archive retention period", description="Applicable to releases and workflows")
    private Integer maximumArchiveRetentionPeriod;
    @Property(defaultValue="40 0/10 * * * *", required=false, hidden=true, label="Schedule for the job that checks for releases to purge from the archive (advanced)")
    private String purgingJobCronSchedule;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of purgable releases to retrieve from the repository in a single search query")
    private Integer purgingSearchPageSize;
    @Property(defaultValue="30", required=false, hidden=true, label="Number of seconds that purging is allowed to run before it is paused until the next time it is scheduled")
    private Integer purgingMaxSecondsPerRun;
    @Property(defaultValue="1", required=false, hidden=true, label="Number of seconds to sleep between purging individual releases within a single run")
    private Integer purgingSleepSecondsBetweenReleases;
    @Property(defaultValue="false", required=false, label="Allow executions to skip archiving", description="When checked, release and workflow executions can be configured to skip archiving")
    private boolean skipArchiveAllowed;
    @Property(defaultValue="false", required=false, label="Enable automatic abort of stale executions")
    private boolean releaseCleanupEnabled;
    @Property(defaultValue="2160", required=false, label="Abort long running executions older than", description="Applicable to releases and workflows")
    private Integer releaseAgeToAbort;
    @Property(defaultValue="1", required=false, hidden=true, label="Number of seconds to sleep between aborting individual releases and workflow executions within a single run")
    private Integer releaseCleanupSleepSecondsBetweenAbort;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of stale releases and workflow executions to retrieve from the repository in a single search query")
    private Integer releaseCleanupSearchPageSize;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of seconds that releases and workflow executions aborting is allowed to run before it is paused until the next time it is scheduled")
    private Integer releaseCleanupMaxSecondsPerRun;
    @Property(defaultValue="46 0/5 0-8,20-23 * * *", required=false, hidden=true, label="Schedule for the job that checks for stale releases and workflow executions to abort (advanced)")
    private String releaseCleanupCronSchedule;

    public void validate() {
        Preconditions.checkArgument((this.releaseAgeToDeleteFromJcr >= 0 ? 1 : 0) != 0, (Object)"releaseAgeToDeleteFromJcr must be greater than or equal to 0 hours.");
        if (this.purgingEnabled) {
            Preconditions.checkArgument((this.maximumArchiveRetentionPeriod >= 1 ? 1 : 0) != 0, (Object)"If purging is enabled the maximumArchiveRetentionPeriod must be greater than or equal to 1 hour");
        }
        Preconditions.checkArgument((this.releaseAgeToAbort >= 1 ? 1 : 0) != 0, (Object)"releaseAgeToAbort must be greater than or equal to 1 hours.");
    }

    public Integer getReleaseAgeToDeleteFromJcr() {
        return this.releaseAgeToDeleteFromJcr;
    }

    public String getArchivingJobCronSchedule() {
        return this.archivingJobCronSchedule;
    }

    public void setReleaseAgeToDeleteFromJcr(Integer releaseAgeToDeleteFromJcr) {
        this.releaseAgeToDeleteFromJcr = releaseAgeToDeleteFromJcr;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getPreArchivingEnabled() {
        return this.preArchivingEnabled;
    }

    public void setPreArchivingEnabled(Boolean enabled) {
        this.preArchivingEnabled = enabled;
    }

    public Integer getSearchPageSize() {
        return this.searchPageSize;
    }

    public Integer getMaxSecondsPerRun() {
        return this.maxSecondsPerRun;
    }

    public Integer getSleepSecondsBetweenReleases() {
        return this.sleepSecondsBetweenReleases;
    }

    public boolean getPurgingEnabled() {
        return this.purgingEnabled;
    }

    public void setPurgingEnabled(boolean enabled) {
        this.purgingEnabled = enabled;
    }

    public String getPurgeExportPath() {
        return this.purgeExportPath;
    }

    public void setPurgeExportPath(String location) {
        this.purgeExportPath = location;
    }

    public boolean getExportOnPurgeEnabled() {
        return this.exportOnPurgeEnabled;
    }

    public void setExportOnPurgeEnabled(boolean enabled) {
        this.exportOnPurgeEnabled = enabled;
    }

    public Integer getMaximumArchiveRetentionPeriod() {
        return this.maximumArchiveRetentionPeriod;
    }

    public void setMaximumArchiveRetentionPeriod(Integer maximumArchiveRetentionPeriod) {
        this.maximumArchiveRetentionPeriod = maximumArchiveRetentionPeriod;
    }

    public String getPurgingJobCronSchedule() {
        return this.purgingJobCronSchedule;
    }

    public Integer getPurgingSearchPageSize() {
        return this.purgingSearchPageSize;
    }

    public Integer getPurgingMaxSecondsPerRun() {
        return this.purgingMaxSecondsPerRun;
    }

    public Integer getPurgingSleepSecondsBetweenReleases() {
        return this.purgingSleepSecondsBetweenReleases;
    }

    public boolean getSkipArchiveAllowed() {
        return this.skipArchiveAllowed;
    }

    public void setSkipArchiveAllowed(boolean skipArchiveAllowed) {
        this.skipArchiveAllowed = skipArchiveAllowed;
    }

    public boolean isReleaseCleanupEnabled() {
        return this.releaseCleanupEnabled;
    }

    public void setReleaseCleanupEnabled(boolean releaseCleanupEnabled) {
        this.releaseCleanupEnabled = releaseCleanupEnabled;
    }

    public Integer getReleaseAgeToAbort() {
        return this.releaseAgeToAbort;
    }

    public void setReleaseAgeToAbort(Integer releaseAgeToAbort) {
        this.releaseAgeToAbort = releaseAgeToAbort;
    }

    public Integer getReleaseCleanupSleepSecondsBetweenAbort() {
        return this.releaseCleanupSleepSecondsBetweenAbort;
    }

    public void setReleaseCleanupSleepSecondsBetweenAbort(Integer releaseCleanupSleepSecondsBetweenAbort) {
        this.releaseCleanupSleepSecondsBetweenAbort = releaseCleanupSleepSecondsBetweenAbort;
    }

    public Integer getReleaseCleanupSearchPageSize() {
        return this.releaseCleanupSearchPageSize;
    }

    public void setReleaseCleanupSearchPageSize(Integer releaseCleanupSearchPageSize) {
        this.releaseCleanupSearchPageSize = releaseCleanupSearchPageSize;
    }

    public Integer getReleaseCleanupMaxSecondsPerRun() {
        return this.releaseCleanupMaxSecondsPerRun;
    }

    public void setReleaseCleanupMaxSecondsPerRun(Integer releaseCleanupMaxSecondsPerRun) {
        this.releaseCleanupMaxSecondsPerRun = releaseCleanupMaxSecondsPerRun;
    }

    public String getReleaseCleanupCronSchedule() {
        return this.releaseCleanupCronSchedule;
    }

    public void setReleaseCleanupCronSchedule(String releaseCleanupCronSchedule) {
        this.releaseCleanupCronSchedule = releaseCleanupCronSchedule;
    }
}

