/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false, virtual=true)
public abstract class BaseArtifact
extends BaseConfigurationItem
implements SourceArtifact {
    public static final String PARENT_TITLE_PROPERTY_NAME = "parentTitle";
    public static final String PORTABLE_FILENAME_PROPERTY_NAME = "portableFilename";
    public static final String EXPORT_FILENAME_PROPERTY_NAME = "exportFilename";
    public static final String CONTENT_TYPE_PROPERTY_NAME = "contentType";
    private OverthereFile file;
    @Property
    private String contentType;
    @Property(isTransient=true)
    private String exportFilename;
    @Property(isTransient=true)
    private String portableFilename;
    @Property(isTransient=true)
    private String parentTitle;
    @Property
    private String fileUri;

    protected BaseArtifact() {
    }

    protected BaseArtifact(OverthereFile file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    public OverthereFile getFile() {
        return this.file;
    }

    public void setFile(OverthereFile file) {
        this.file = file;
    }

    public Set<String> getPlaceholders() {
        return Collections.emptySet();
    }

    public void setPlaceholders(Set<String> placeholders) {
    }

    public String getTextFileNamesRegex() {
        return "";
    }

    public String getExcludeFileNamesRegex() {
        return "";
    }

    public Map<String, String> getFileEncodings() {
        return Collections.emptyMap();
    }

    public String getChecksum() {
        return "";
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public abstract String getExportDirectoryName();

    private String buildExportFileName() {
        if (null != this.getFile()) {
            return this.getExportDirectoryName() + "/" + this.getName() + "-" + this.getFile().getName();
        }
        return null;
    }

    public String getExportFilename() {
        if (this.exportFilename == null) {
            this.exportFilename = this.buildExportFileName();
        }
        return this.exportFilename;
    }

    public void setExportFilename(String exportFilename) {
        this.exportFilename = exportFilename;
    }

    public String getPortableFilename() {
        if (null == this.portableFilename) {
            this.portableFilename = this.buildPortableFilename();
        }
        return this.portableFilename;
    }

    public void setPortableFilename(String portableFilename) {
        this.portableFilename = portableFilename;
    }

    private String buildPortableFilename() {
        if (null != this.getFile()) {
            return this.getExportDirectoryName() + "/" + this.getParentPrefix() + this.getFile().getName();
        }
        return null;
    }

    private String hash(String value) {
        return DigestUtils.sha1Hex((String)value);
    }

    private String getParentPrefix() {
        return this.parentTitle != null ? this.hash(this.parentTitle) + "/" : "";
    }
}

