/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.status;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum ReleaseStatus {
    TEMPLATE("template"),
    PLANNED("planned"),
    IN_PROGRESS("in_progress"),
    PAUSED("paused"),
    FAILING("failing"),
    FAILED("failed"),
    COMPLETED("completed"),
    ABORTED("aborted");

    public static final ReleaseStatus[] RECOVERABLE_STATUSES;
    public static final ReleaseStatus[] ACTIVE_STATUSES;
    public static final ReleaseStatus[] INACTIVE_STATUSES;
    private final String value;

    private ReleaseStatus(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public boolean isActive() {
        return Arrays.stream(ACTIVE_STATUSES).anyMatch(active -> this == active);
    }

    public boolean isInactive() {
        return Arrays.stream(INACTIVE_STATUSES).anyMatch(active -> this == active);
    }

    public boolean hasBeenStarted() {
        return this != TEMPLATE && this != PLANNED;
    }

    public static EnumSet<ReleaseStatus> toEnumSet(ReleaseStatus ... statuses) {
        return statuses.length > 0 ? EnumSet.of(statuses[0], statuses) : EnumSet.noneOf(ReleaseStatus.class);
    }

    public static Set<String> namesOf(ReleaseStatus ... statuses) {
        return ReleaseStatus.namesOf(ReleaseStatus.toEnumSet(statuses));
    }

    public static Set<String> namesOf(EnumSet<ReleaseStatus> statuses) {
        return statuses.stream().map(Enum::name).collect(Collectors.toSet());
    }

    static {
        RECOVERABLE_STATUSES = new ReleaseStatus[]{IN_PROGRESS, FAILING, PAUSED};
        ACTIVE_STATUSES = new ReleaseStatus[]{IN_PROGRESS, FAILED, FAILING, PAUSED};
        INACTIVE_STATUSES = new ReleaseStatus[]{COMPLETED, ABORTED};
    }
}

