package com.xebialabs.xlrelease.domain.distributed.events

/**
 * Common interface for domain events related to task udpates
 */
sealed trait DistributedTaskUpdatedEvents extends DistributedXLReleaseEvent {
  def taskId: String
  def author: String
}

/**
 * Event published when a task's properties have been updated.
 *
 */
case class DistributedTaskUpdatedEvent(taskId: String, author: String) extends DistributedTaskUpdatedEvents

