package com.xebialabs.xlrelease.domain.environments;

import java.util.Date;
import java.util.Objects;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(
        description = "Entity that represents current state of deployment",
        versioned = false,
        root = Metadata.ConfigurationItemRoot.CONFIGURATION
)
@JsonSerialize(using = CiSerializer.class)
public class DeploymentState extends BaseConfiguration {
    @Property(description = "General status of deployment, value of Status Group can be one of: success, in-progress, failed.")
    private String statusGroup;
    @Property(description = "Deployment provider status label, value of a Status can be anything that is defined by deployment provider.")
    private String status;
    @Property(description = "Direct link to deployed application defined by deployment provider.")
    private String deploymentLink;

    @Property(description = "Deployment version tag defined by deployment provider.")
    private String versionTag;
    @Property(description = "Deloyment version state, e.g. if deployment provider is GitOps driven value would be Synced/OutOfSync.")
    private String versionState;

    @Property(description = "Tooltip shown for version tag defined by deployment provider.")
    private String versionTooltip;
    @Property(description = "Link to deployed version of application defined by deployment provider.")
    private String versionLink;

    @Property(description = "Deployment type which lead to version change within deployment provider.")
    private String deploymentType;
    @Property(description = "User which initiated or triggered deployment withing deployment provider.")
    private String user;
    @Property(description = "Date and time of last deployment state change.")
    private Date lastChangeTime;

    public static DeploymentState create(
            String statusGroup,
            String status,
            String deepLink,
            String versionTag,
            String versionState,
            String versionLink,
            String versionTooltip,
            String deploymentType,
            String user,
            Date time
    ) {
        var liveDeployment = new DeploymentState();
        liveDeployment.setStatusGroup(statusGroup);
        liveDeployment.setStatus(status);
        liveDeployment.setDeploymentLink(deepLink);
        liveDeployment.setVersionTag(versionTag);
        liveDeployment.setVersionState(versionState);
        liveDeployment.setVersionLink(versionLink);
        liveDeployment.setVersionTooltip(versionTooltip);
        liveDeployment.setDeploymentType(deploymentType);
        liveDeployment.setUser(user);
        liveDeployment.setLastChangeTime(time);
        return liveDeployment;
    }

    public String getStatusGroup() {
        return statusGroup;
    }

    public void setStatusGroup(String statusGroup) {
        this.statusGroup = statusGroup;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getVersionTag() {
        return versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    public String getVersionState() {
        return versionState;
    }

    public void setVersionState(String versionState) {
        this.versionState = versionState;
    }

    public String getDeploymentType() {
        return deploymentType;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getLastChangeTime() {
        return lastChangeTime;
    }

    public void setLastChangeTime(Date lastChangeTime) {
        this.lastChangeTime = lastChangeTime;
    }

    public String getDeploymentLink() {
        return deploymentLink;
    }

    public void setDeploymentLink(final String deploymentLink) {
        this.deploymentLink = deploymentLink;
    }

    public String getVersionTooltip() {
        return versionTooltip;
    }

    public void setVersionTooltip(final String versionTooltip) {
        this.versionTooltip = versionTooltip;
    }

    public String getVersionLink() {
        return versionLink;
    }

    public void setVersionLink(final String versionLink) {
        this.versionLink = versionLink;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DeploymentState that = (DeploymentState) o;
        return Objects.equals(statusGroup, that.statusGroup) &&
                Objects.equals(status, that.status) &&
                Objects.equals(deploymentLink, that.deploymentLink) &&
                Objects.equals(versionTag, that.versionTag) &&
                Objects.equals(versionState, that.versionState) &&
                Objects.equals(versionTooltip, that.versionTooltip) &&
                Objects.equals(versionLink, that.versionLink) &&
                Objects.equals(deploymentType, that.deploymentType) &&
                Objects.equals(user, that.user) &&
                Objects.equals(lastChangeTime, that.lastChangeTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), statusGroup, status, deploymentLink, versionTag, versionState, versionTooltip, versionLink, deploymentType, user, lastChangeTime);
    }
}
