package com.xebialabs.xlrelease.risk.domain;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.ReleaseExtension;

@Metadata(versioned = false, description = "Summary of risk calculations. Risk calculates the health of the release and how severe are issues")
@PublicApiRef
@ShowOnlyPublicApiMembers
public class Risk extends ReleaseExtension {

    public static final String RISK_PREFIX = "Risk";

    @Property(defaultValue = "0", description = "Maximum of all assessments scores")
    private Integer score = 0;

    @Property(defaultValue = "0", description = "Sum of scores of all assessments")
    private Integer totalScore = 0;

    @Property(asContainment = true, description = "List of assessments", required = false)
    private List<RiskAssessment> riskAssessments = new ArrayList<>();

    @PublicApiMember
    public Integer getScore() {
        return score;
    }

    public void setScore(final Integer score) {
        this.score = score;
    }

    @PublicApiMember
    public Integer getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(final Integer totalScore) {
        this.totalScore = totalScore;
    }

    @PublicApiMember
    public List<RiskAssessment> getRiskAssessments() {
        return riskAssessments;
    }

    public void setRiskAssessments(final List<RiskAssessment> riskAssessments) {
        this.riskAssessments = new ArrayList<>(riskAssessments);
    }
}
