package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false, label = "Audit reports", description = "Release will use these settings to manage the lifecycle and data available to Audit reports.")
public class AuditReportSettings extends BaseSettings {

    public static final String AUDIT_REPORT_SETTINGS_ID = BASE_ID + "AuditReportSettings";

    @Property(defaultValue = "calendar", hidden = true)
    private String displayIcon;

    @Property(defaultValue = "reports-settings", hidden = true)
    private String displayPage;

    @Property(defaultValue = "concept/release-audit-report.html", hidden = true)
    private String documentationPage;

    @Property(defaultValue = "0", hidden = true)
    private Integer weight;

    @Property(defaultValue = "10", required = false, label = "Delete Release Audit reports older than",
            description = "Release will use this setting to delete release audit reports that have been generated on the server. After deletion, release audit reports can no longer be downloaded.")
    private Integer reportsRetentionPeriod; // in days

    @Property(label = "Record historical changes in folder and global permissions",
            description = "Each data change will trigger the storage of full membership and permission details for inclusion in the Audit report's Permissions sheet. Please note that enabling this feature may lead to significant increase in database size.",
            category = "input",
            defaultValue = "false")
    private boolean generatePermissionSnapshots = false;

    public void validate() {
        Preconditions.checkArgument(reportsRetentionPeriod > 0, "Audit report retention period must be greater than 0 days.");
    }

    public Integer getReportsRetentionPeriod() {
        return reportsRetentionPeriod;
    }

    public void setReportsRetentionPeriod(Integer reportsRetentionPeriod) {
        this.reportsRetentionPeriod = reportsRetentionPeriod;
    }

    public boolean isGeneratePermissionSnapshots() {
        return generatePermissionSnapshots;
    }

    public void setGeneratePermissionSnapshots(final boolean generatePermissionSnapshots) {
        this.generatePermissionSnapshots = generatePermissionSnapshots;
    }
}
