package com.xebialabs.xlrelease.configuration;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false, label = "Customization")
public class ThemeSettings extends BaseSettings {
    public static final String THEME_SETTINGS_ID = BASE_ID + "ThemeSettings";

    @Property(defaultValue = "configuration-preferences", hidden = true)
    private String displayIcon;

    @Property(defaultValue = "general-settings", hidden = true)
    private String displayPage;

    @Property(defaultValue = "how-to/configure-general-settings.html", hidden = true)
    private String documentationPage;

    @Property(defaultValue = "0", hidden = true)
    private Integer weight;

    @Property(required = false, label = "Instance name", description = "Name of the Release environment (e.g., Development, Production)")
    private String headerName;

    @Property(defaultValue = "GREEN", required = false, label = "Header color")
    private String headerAccentColor = ThemeColor.GREEN.name();

    @Property(required = false, label = "Description")
    private String description;

    @Property(required = false, label = "Login message", description = "Message that appears on Login screen if set")
    private String loginMessage;

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public String getHeaderAccentColor() {
        return headerAccentColor;
    }

    public void setHeaderAccentColor(final String headerAccentColor) {
        this.headerAccentColor = headerAccentColor;
    }

    public String getHeaderName() {
        return headerName;
    }

    public void setHeaderName(final String headerName) {
        this.headerName = headerName;
    }

    // This value is used in the mustache templates
    public String getHeaderAccentColorCode() {
        return ThemeColors.colorCode(ThemeColor.valueOf(this.headerAccentColor));
    }

    public String getLoginMessage() {
        return loginMessage;
    }

    public void setLoginMessage(String loginMessage) {
        this.loginMessage = loginMessage;
    }
}
