package com.xebialabs.xlrelease.domain.environments;

import java.util.Objects;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(
        description = "External system entity that is deployed to an DeploymentTarget",
        versioned = false,
        root = Metadata.ConfigurationItemRoot.CONFIGURATION,
        virtual = true
)
public class ApplicationSource extends BaseConfigurationItem {
    @Property(description = "Application Source server URL. Actual connection URL where the Application is defined.")
    private String serverUrl;

    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ApplicationSource that = (ApplicationSource) o;
        return Objects.equals(serverUrl, that.serverUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), serverUrl);
    }
}
