package com.xebialabs.xlrelease.domain.environments;

import java.util.Objects;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(
        description = "External system entity that represents place of deployment for ApplicationSource",
        versioned = false,
        root = Metadata.ConfigurationItemRoot.CONFIGURATION,
        virtual = true
)
public class DeploymentTarget extends BaseConfigurationItem {
    @Property(description = "Target server URL. Actual URL to the target where application is deployed to.")
    private String targetUrl;

    public String getTargetUrl() {
        return targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DeploymentTarget that = (DeploymentTarget) o;
        return Objects.equals(targetUrl, that.targetUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), targetUrl);
    }
}
