package com.xebialabs.xlrelease.domain.environments;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import java.util.ArrayList;
import java.util.List;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(description = "Representation of an artifact that can be deployed to an environment.", versioned = false, root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Application extends BaseConfiguration {
    @Property(description = "Name of the application")
    private String title;

    @Property(description = "External system Unique correlation ID for Application", readonly = true)
    private String correlationUid;

    @Property(required = false, nested = true)
    private ApplicationSource applicationSource;

    @Property(required = false, description = "Environments attached to this application")
    private List<Environment> environments = new ArrayList<>();

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(final String title) {
        this.title = title;
    }

    public String getCorrelationUid() {
        return correlationUid;
    }

    public void setCorrelationUid(String correlationUid) {
        this.correlationUid = correlationUid;
    }

    @PublicApiMember
    public List<Environment> getEnvironments() {
        return environments;
    }

    @PublicApiMember
    public void setEnvironments(final List<Environment> environments) {
        this.environments = environments;
    }

    public ApplicationSource getApplicationSource() {
        return applicationSource;
    }

    public void setApplicationSource(ApplicationSource applicationSource) {
        this.applicationSource = applicationSource;
    }
}
