package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.folder.Folder

/**
  * Common interface for domain events related to modification of folders.
  */
sealed trait FolderEvent extends XLReleaseEvent

/**
  * Event published when a folder is moved.
  *
  * @param folder the moved folder.
  */
case class FolderMovedEvent(folder: Folder, oldParentId: String, newParentId: String) extends FolderEvent

/**
  * Event published when a folder is deleted.
  *
  * @param folder the deleted folder.
  */
case class FolderDeletedEvent(folder: Folder) extends FolderEvent

/**
  * Event published when a folder is created.
  *
  * @param folder the created folder.
  */
case class FolderCreatedEvent(folder: Folder) extends FolderEvent

/**
  * Event published when a folder is renamed.
  *
  * @param folder the folder to rename.
  * @param newName the new name of the folder.
  */
case class FolderRenamedEvent(folder: Folder, newName: String) extends FolderEvent