package com.xebialabs.xlrelease.domain.runner

import com.xebialabs.xlrelease.domain.RemoteExecution

trait JobRunnerOps {

  def accepts(runner: JobRunner): Boolean

  def start(runner: JobRunner): Unit

  def stop(runner: JobRunner): Unit

  def delete(runner: JobRunner): Unit

  def abortJob(runner: JobRunner, jobId: Long, executionId: String): Unit

  def execute(runner: JobRunner, remoteExecution: RemoteExecution): String
}


object JobRunnerOps extends JobRunnerOps {

  import scala.jdk.CollectionConverters._

  private var _jobRunnerOps: java.util.Set[JobRunnerOps] = new java.util.HashSet[JobRunnerOps]()

  def apply(jobRunnerOps: java.util.Set[JobRunnerOps]): JobRunnerOps = {
    this._jobRunnerOps = jobRunnerOps
    this
  }

  private def findOps(runner: JobRunner): JobRunnerOps = {
    this._jobRunnerOps.asScala.find(_.accepts(runner))
      .getOrElse(throw new IllegalStateException(s"Runner [$runner] does not have associated Ops"))
  }

  override def start(runner: JobRunner): Unit = {
    findOps(runner).start(runner)
  }

  override def stop(runner: JobRunner): Unit = {
    findOps(runner).stop(runner)
  }

  override def delete(runner: JobRunner): Unit = {
    findOps(runner).delete(runner)
  }

  override def abortJob(runner: JobRunner, jobId: Long, executionId: String): Unit = {
    findOps(runner).abortJob(runner, jobId, executionId)
  }

  override def accepts(runner: JobRunner): Boolean = true

  override def execute(runner: JobRunner, remoteExecution: RemoteExecution): String = {
    findOps(runner).execute(runner, remoteExecution)
  }

}
