package com.xebialabs.xlrelease.domain.status;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static java.util.stream.Collectors.toSet;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum ReleaseStatus {

    TEMPLATE("template"),
    PLANNED("planned"),
    IN_PROGRESS("in_progress"),
    PAUSED("paused"),
    FAILING("failing"),
    FAILED("failed"),
    COMPLETED("completed"),
    ABORTED("aborted");

    public static final ReleaseStatus[] RECOVERABLE_STATUSES = new ReleaseStatus[]{IN_PROGRESS, FAILING, PAUSED};
    public static final ReleaseStatus[] ACTIVE_STATUSES = new ReleaseStatus[]{IN_PROGRESS, FAILED, FAILING, PAUSED};
    public static final ReleaseStatus[] INACTIVE_STATUSES = new ReleaseStatus[]{COMPLETED, ABORTED};

    private final String value;

    ReleaseStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public boolean isActive() {
        return Arrays.stream(ACTIVE_STATUSES).anyMatch(active -> this == active);
    }

    public boolean isInactive() { return Arrays.stream(INACTIVE_STATUSES).anyMatch(active -> this == active); }

    public boolean hasBeenStarted() {
        return this != TEMPLATE && this != PLANNED;
    }

    public static EnumSet<ReleaseStatus> toEnumSet(ReleaseStatus... statuses) {
        return statuses.length > 0 ? EnumSet.of(statuses[0], statuses) : EnumSet.noneOf(ReleaseStatus.class);
    }

    public static Set<String> namesOf(ReleaseStatus... statuses) {
        return namesOf(ReleaseStatus.toEnumSet(statuses));
    }

    public static Set<String> namesOf(EnumSet<ReleaseStatus> statuses) {
        return statuses.stream().map(ReleaseStatus::name).collect(toSet());
    }

}
