package com.xebialabs.xlrelease.domain.udm.reporting;

import java.util.Date;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;

import static com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label = "Security and Compliance", description = "Unified Data Model for Code Compliance")
public class CodeComplianceRecord extends TaskReportingRecord {

    @Property(category = CATEGORY_INPUT, label = "Project", description = "The project name.")
    private String project;

    @Property(category = CATEGORY_INPUT, label = "Project URL", description = "URL for the project.")
    private String project_url;

    @Property(category = CATEGORY_INPUT, label = "Analysis date", description = "Date of the analysis.")
    private Date analysisDate;

    @Property(category = CATEGORY_INPUT, label = "Compliance check", description = "Result of the analysis.")
    private String outcome;

    @Property(category = CATEGORY_INPUT, label = "Compliance data", description = "The compliance data.")
    private String complianceData;

    @PublicApiMember
    public String getProject() {
        return project;
    }

    @PublicApiMember
    public void setProject(final String project) {
        this.project = project;
    }

    @PublicApiMember
    public String getProject_url() {
        return project_url;
    }

    @PublicApiMember
    public void setProject_url(final String project_url) {
        this.project_url = project_url;
    }

    @PublicApiMember
    public Date getAnalysisDate() {
        return analysisDate;
    }

    @PublicApiMember
    public void setAnalysisDate(final Date analysisDate) {
        this.analysisDate = analysisDate;
    }

    @PublicApiMember
    public String getOutcome() {
        return outcome;
    }

    @PublicApiMember
    public void setOutcome(final String outcome) {
        this.outcome = outcome;
    }

    @PublicApiMember
    public String getComplianceData() {
        return complianceData;
    }

    @PublicApiMember
    public void setComplianceData(final String complianceData) {
        this.complianceData = complianceData;
    }
}
