/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables.reference;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UserInputTaskUsagePoint
implements UsagePoint {
    private final CiProperty property;
    private final UserInputTask task;
    private Variable variable;

    public UserInputTaskUsagePoint(UserInputTask task, String property, Variable variable) {
        this.task = task;
        this.property = CiProperty.of((ConfigurationItem)task, property).get();
        this.variable = variable;
    }

    @Override
    public Map<String, VariableReference.VariableUsageType> collectVariables() {
        HashMap<String, VariableReference.VariableUsageType> vars = new HashMap<String, VariableReference.VariableUsageType>();
        vars.put(VariableHelper.withVariableSyntax(this.variable.getKey()), VariableReference.VariableUsageType.DEFAULT);
        return vars;
    }

    @Override
    public Set<ConfigurationItem> replaceVariable(Variable variable, VariableOrValue replacement) {
        HashSet<ConfigurationItem> modifiedItems = new HashSet<ConfigurationItem>();
        if (null != replacement.getVariable()) {
            String replacementVariableKey = VariableHelper.withoutVariableSyntax(replacement.getVariable());
            Variable newVariable = this.task.getRelease().getVariablesByKeys().get(replacementVariableKey);
            if (null == newVariable) {
                this.removeVariableFromTask(variable);
            } else {
                List<Variable> newTaskVariables = this.task.getVariables().stream().map(v -> v.getKey().equals(variable.getKey()) ? newVariable : v).distinct().collect(Collectors.toList());
                this.task.setVariables(newTaskVariables);
            }
        } else {
            this.removeVariableFromTask(variable);
        }
        modifiedItems.add((ConfigurationItem)this.task);
        return modifiedItems;
    }

    private boolean removeVariableFromTask(Variable variable) {
        return this.task.getVariables().removeIf(v -> v.getKey().equals(variable.getKey()));
    }

    @Override
    public CiProperty getTargetProperty() {
        return this.property;
    }
}

