package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false, label = "Task polling", description = "Status interval refreshes the Tasks and Release flow screens automatically when the task status changes. List interval refreshes the list of tasks to be polled on Tasks screen.")
public class PollingSettings extends BaseSettings {
    public static final String POLLING_SETTINGS_ID = BASE_ID + "PollingSettings";

    @Property(defaultValue = "task", hidden = true)
    private String displayIcon;

    @Property(defaultValue = "tasks-settings", hidden = true)
    private String displayPage;

    @Property(defaultValue = "how-to/configure-tasks", hidden = true)
    private String documentationPage;

    @Property(defaultValue = "10", hidden = true)
    private Integer weight;

    @Property(defaultValue = "5", required = false, label = "Refresh Task status every")
    private Integer taskStatusInterval;

    @Property(defaultValue = "60", required = false, label = "Refresh Task list  every")
    private Integer taskListInterval;

    public Integer getTaskStatusInterval() {
        return taskStatusInterval;
    }

    public void setTaskStatusInterval(Integer taskStatusInterval) {
        this.taskStatusInterval = taskStatusInterval;
    }

    public Integer getTaskListInterval() {
        return taskListInterval;
    }

    public void setTaskListInterval(Integer taskListInterval) {
        this.taskListInterval = taskListInterval;
    }

    public void validate() {
        Preconditions.checkArgument(taskStatusInterval > 0, "Task status polling interval must be greater than 0 seconds.");
        Preconditions.checkArgument(taskListInterval > 0, "Task list polling interval must be greater than 0 seconds.");
    }
}
